create or replace package tbicds.PCK_PATIENT_EVENTS
AUTHID CURRENT_USER
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  --return recordsets
  type RetRefCursor is ref cursor;

  procedure GetPatientEventsRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vPatientID       in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor);

  procedure GetAllPatientEventsRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor);

  procedure CheckPatMessagesPrefs(pi_vKey       in varchar2,
                                  pi_vPatientID in varchar2,
                                  po_nTextMsg   out number,
                                  po_nEmail     out number);

  procedure SendInternalNotification(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vKey       in varchar2,
                                     pi_vPatientID in varchar2,
                                     pi_nEventID   in number,
                                     
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2);

  procedure CompletedEvent(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vKey       in varchar2,
                           pi_vPatientID in varchar2,
                           pi_nEventID   in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2);

  procedure AddAllEvents(pi_vSessionID       in varchar2,
                         pi_vSessionClientIP in varchar2,
                         pi_nUserID          in number,
                         
                         pi_vPatientID in varchar2,
                         
                         po_nStatusCode    out number,
                         po_vStatusComment out varchar2);

  procedure UpdatePatientEvent(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               
                               pi_vKey       in varchar2,
                               pi_vPatientID in varchar2,
                               pi_nEventID   in number,
                               pi_vEventDate in varchar2,
                               pi_nStatus    in number,
                               pi_vComments  in varchar2,
                               
                               po_nStatusCode    out number,
                               po_vStatusComment out varchar2);

  procedure SendEventNotification(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  
                                  pi_vKey       in varchar2,
                                  pi_vPatientID in varchar2,
                                  pi_nEventID   in number,
                                  
                                  po_nStatusCode    out number,
                                  po_vStatusComment out varchar2);

  procedure GetStatEventsRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor);

  procedure AddSpecificEvent(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vPatientID       in varchar2,
                             pi_nEventID         in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2);

  procedure CompletedSpecificEvent(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vKey             in varchar2,
                                   pi_vPatientID       in varchar2,
                                   pi_nEventID         in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2);

  procedure AssignModuleGroupEvent(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   
                                   pi_vPatientID  in varchar2,
                                   pi_nEventID    in number,
                                   pi_dtEventDate in date,
                                   
                                   po_nStatusCode    out number,
                                   po_vStatusComment out varchar2);

  procedure SendPatEventReminder(pi_vKey           in varchar2,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2);

  procedure SendInternalReminder(pi_vKey           in varchar2,
                                 pi_vPatientID     in varchar2,
                                 pi_nEventID       in number,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2);

  procedure SendEventReminder(pi_vKey           in varchar2,
                              pi_vPatientID     in varchar2,
                              pi_nEventID       in number,
                              po_nStatusCode    out number,
                              po_vStatusComment out varchar2);

  procedure GetPatByEvtDueDateRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 
                                 pi_vKey   in varchar2,
                                 pi_vDate1 in varchar2,
                                 pi_vDate2 in varchar2,
                                 
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2,
                                 rs                out RetRefCursor);

  procedure GetPatByOverdueEvtRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vKey             in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor);

  procedure GetAllPatientsListRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vKey             in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out Pck_Utl_Common.refCursor);

  function IsEventDateReadOnly(pi_vPatientID in varchar2,
                               pi_nEventID   in number) return number;

  procedure CheckPAPEventALL(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             
                             pi_vKey in varchar2,
                             
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2);

  procedure CheckPAPEvent(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          
                          pi_vKey       in varchar2,
                          pi_vPatientID in varchar2,
                          
                          po_nStatusCode    out number,
                          po_vStatusComment out varchar2);

  function UpdateStatusDate(pi_vPatientID in varchar2,
                            pi_nEventID   in number,
                            pi_nStatus    in number,
                            pi_vEventDate in varchar2) return number;

  -- Get JSON string of patient events
  procedure GetAllPatEventsJSONRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vKey             in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor);

end;
/

